#ifndef _KPCIDIO_H
#define _KPCIDIO_H

#if defined(INCLUDE_AFTER_WINDOWS_H) && !defined(_INC_WINDOWS)
#error  This header must be included before utility.h and formatio.h
#error  because it includes cviauto.h which includes Windows SDK headers.
#endif /* INCLUDE_AFTER_WINDOWS_H */

#include <cviauto.h>

#ifdef __cplusplus
    extern "C" {
#endif
HRESULT CVIFUNC KPCIDIOLib_NewIKPCIPIO (const char *server,

                                        int supportMultithreading, LCID locale,
                                        int reserved, CAObjHandle *objectHandle);

HRESULT CVIFUNC KPCIDIOLib_OpenIKPCIPIO (const char *fileName,
                                         const char *server,
                                         int supportMultithreading, LCID locale,
                                         int reserved, CAObjHandle *objectHandle);

HRESULT CVIFUNC KPCIDIOLib_ActiveIKPCIPIO (const char *server,
                                           int supportMultithreading,
                                           LCID locale, int reserved,
                                           CAObjHandle *objectHandle);

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOOpenDevice (CAObjHandle objectHandle,
                                               ERRORINFO *errorInfo, long device);

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOCloseDevice (CAObjHandle objectHandle,
                                                ERRORINFO *errorInfo);

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIORead (CAObjHandle objectHandle,
                                         ERRORINFO *errorInfo, short offset,
                                         unsigned char *returnValue);

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOWrite (CAObjHandle objectHandle,
                                          ERRORINFO *errorInfo, short offset,
                                          unsigned char value);

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOGetOpenCount (CAObjHandle objectHandle,
                                                 ERRORINFO *errorInfo,
                                                 long *returnValue);

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOGetDevice (CAObjHandle objectHandle,
                                              ERRORINFO *errorInfo,
                                              long *returnValue);

HRESULT CVIFUNC KPCIDIOLib_NewIHardware (const char *server,
                                         int supportMultithreading, LCID locale,
                                         int reserved, CAObjHandle *objectHandle);

HRESULT CVIFUNC KPCIDIOLib_OpenIHardware (const char *fileName,
                                          const char *server,
                                          int supportMultithreading, LCID locale,
                                          int reserved,
                                          CAObjHandle *objectHandle);

HRESULT CVIFUNC KPCIDIOLib_ActiveIHardware (const char *server,
                                            int supportMultithreading,
                                            LCID locale, int reserved,
                                            CAObjHandle *objectHandle);

HRESULT CVIFUNC KPCIDIOLib_IHardwareReadRegister8 (CAObjHandle objectHandle,
                                                   ERRORINFO *errorInfo,
                                                   short offset,
                                                   unsigned char *returnValue);

HRESULT CVIFUNC KPCIDIOLib_IHardwareReadRegister16 (CAObjHandle objectHandle,
                                                    ERRORINFO *errorInfo,
                                                    short offset,
                                                    short *returnValue);

HRESULT CVIFUNC KPCIDIOLib_IHardwareReadRegister32 (CAObjHandle objectHandle,
                                                    ERRORINFO *errorInfo,
                                                    short offset,
                                                    long *returnValue);

HRESULT CVIFUNC KPCIDIOLib_IHardwareWriteRegister8 (CAObjHandle objectHandle,
                                                    ERRORINFO *errorInfo,
                                                    short offset,
                                                    unsigned char value);

HRESULT CVIFUNC KPCIDIOLib_IHardwareWriteRegister16 (CAObjHandle objectHandle,
                                                     ERRORINFO *errorInfo,
                                                     short offset, short value);

HRESULT CVIFUNC KPCIDIOLib_IHardwareWriteRegister32 (CAObjHandle objectHandle,
                                                     ERRORINFO *errorInfo,
                                                     short offset, long value);
#ifdef __cplusplus
    }
#endif
#endif /* _KPCIDIO_H */
